<!-- Footer -->
<?php if (isset($menu) && $menu == TRUE): ?>

    <?php if (settings()->home_layout == 1): ?>
    <footer class="py-6 border-top border-light">

        <div class="container">
            <div class="row pb-2">
                <div class="col-sm-5 col-lg-5 mb-5 mb-lg-0">
                    <img width="150px" src="<?php echo $logo_url ?>" class="w-md-30 mb-2" alt="logo">
                    <p class=""><?php echo lang_value()->footer_about ?></p>
                    <ul class="list-unstyled social-icon2 mb-0">
                        <?php if (!empty($settings->facebook)) : ?>
                            <li><a target="_blank" href="<?= prep_url($settings->facebook) ?>"><i class="lni lni-facebook-original"></i></a></li>
                        <?php endif ?>

                        <?php if (!empty($settings->twitter)) : ?>
                            <li><a target="_blank" href="<?= prep_url($settings->twitter) ?>"><i class="lni lni-twitter"></i></a></li>
                        <?php endif ?>

                        <?php if (!empty($settings->linkedin)) : ?>
                            <li><a target="_blank" href="<?= prep_url($settings->linkedin) ?>"><i class="lni lni-linkedin-original"></i></a></li>
                        <?php endif ?>

                        <?php if (!empty($settings->instagram)) : ?>
                            <li><a target="_blank" href="<?= prep_url($settings->instagram) ?>"><i class="lni lni-instagram-original"></i></a></li>
                        <?php endif ?>
                    </ul>
                </div>

                <div class="col-sm-1 col-lg-1 mb-5 mb-sm-0"></div>

                <div class="col-sm-3 col-lg-3 mb-5 mb-lg-0">
                    <h3 class="h6"><?php echo trans('services') ?></h3>
                    <ul class="footer-list-style-two">
                        <li><a href="<?php echo base_url('pricing') ?>"><?php echo trans('pricing') ?></a></li>
                        
                        <?php if (settings()->enable_blog == 1): ?>
                            <li><a href="<?php echo base_url('blogs') ?>"><?php echo trans('blogs') ?></a></li>
                        <?php endif; ?>

                        <?php if (settings()->enable_faq == 1): ?>
                        <li><a href="<?php echo base_url('faqs') ?>"><?php echo trans('faqs') ?></a></li>
                        <?php endif; ?>

                        <li><a href="<?php echo base_url('contact') ?>"><?php echo trans('contact') ?></a></li>
                    </ul>
                </div>

                <div class="col-sm-3 col-lg-3 mb-5 mb-sm-0">
                    <?php if (!empty(get_front_pages(0))): ?>
                    <h3 class="h6"><?php echo trans('pages') ?></h3>
                    <ul class="footer-list-style-two">
                        <?php foreach (get_front_pages(0) as $page): ?>
                            <li><a href="<?php echo base_url('page/'.$page->slug) ?>"><?php echo html_escape($page->title) ?></a></li>
                        <?php endforeach ?>
                    </ul>
                    <?php endif ?>
                </div>

            </div>
        </div>

        <div class="text-center border-top">
            <div class="container">
                <div class="row py-2">
                    <div class="col-md-12">
                        <p class="mb-0"><?php echo lang_value()->copyright ?></p>
                    </div>
                </div>
            </div>
        </div>

    </footer>
    <?php endif ?>

    <?php if (settings()->home_layout == 2): ?>
    <footer class="py-8 border-top border-light footer-dark">

        <div class="container"> 



            <div class="row pb-5">
                <div class="col-sm-5 col-lg-5 mb-5 mb-lg-0">
                    <img width="150px" src="<?php echo $logo_url ?>" class="w-md-30 mb-2" alt="Aversa Outdoor logo"> 
                    <div>
                            <ul class="list-unstyled social-icon2 mb-0">
                                <?php if (!empty($settings->facebook)) : ?>
                                    <li><a class="btn btn-xs btn-icon btn-dark px-3 fs-13" target="_blank" href="<?= prep_url($settings->facebook) ?>"><i class="lni lni-facebook-original"></i></a></li>
                                <?php endif ?>

                                <?php if (!empty($settings->twitter)) : ?>
                                    <li><a class="btn btn-xs btn-icon btn-dark px-3 fs-13" target="_blank" href="<?= prep_url($settings->twitter) ?>"><i class="lni lni-twitter"></i></a></li>
                                <?php endif ?>

                                <?php if (!empty($settings->linkedin)) : ?>
                                    <li><a class="btn btn-xs btn-icon btn-dark px-3 fs-13" target="_blank" href="<?= prep_url($settings->linkedin) ?>"><i class="lni lni-linkedin-original"></i></a></li>
                                <?php endif ?>

                                <?php if (!empty($settings->instagram)) : ?>
                                    <li><a class="btn btn-xs btn-icon btn-dark px-3 fs-13" target="_blank" href="<?= prep_url($settings->instagram) ?>"><i class="lni lni-instagram-original"></i></a></li>
                                <?php endif ?>
                            </ul>
                        </div>
                </div>

                <div class="col-sm-1 col-lg-1 mb-5 mb-sm-0"></div>

                <div class="col-sm-3 col-lg-3 mb-5 mb-sm-0">
                    <?php if (!empty(get_front_pages(0))): ?>
                    <h3 class="h6 text-light">More Pages</h3>
                    <ul class="footer-list-style-two"> 
                            <li><a class="text-ultra" href="<?php echo base_url('faqs') ?>"><?php echo trans('faqs') ?></a></li> 

                        <li><a class="text-ultra" href="<?php echo base_url('contact') ?>"><?php echo trans('contact') ?></a></li>
                        <li><a class="text-ultra" href="<?php echo base_url('blogs') ?>"><?php echo trans('blogs') ?></a></li> 
 
                    </ul>
                    <?php endif ?>
                </div>


                <div class="col-sm-3 col-lg-3 mb-5 mb-lg-0">
    <h3 class="h6 text-light">Service Areas</h3>

    <ul class="footer-list-style-two">

        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Bradenton</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Lakewood Ranch</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Holmes Beach</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Anna Maria Island</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Bradenton Beach</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Cortez</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Bayshore Gardens</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">Longboat Key</h4></li>
        <li><h4 class="text-ultra m-0" style="font-size:14px; font-weight:600;">St Armands Circle</h4></li>

    </ul>
</div>


            </div>
        </div>

        
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="d-md-flex justify-content-between align-items-center btop-1 pt-4">
                        <div>
                            <p class="mb-xs-2 text-ultra">Copyright 2025, all rights reserved.</p>
                        </div>
                         
                    </div>
                </div>
            </div>
        </div>
       

    </footer>
    <!-- FREE QUOTE POPUP OVERLAY -->
<div id="quotePopup" style="
    position:fixed;
    top:0; left:0;
    width:100%; height:100%;
    background:rgba(0,0,0,0.55);
    display:none;
    justify-content:center;
    align-items:center;
    z-index:9999;
    padding:20px;
">
    <div style="
        background:#fff;
        width:100%; max-width:650px;
        padding:40px;
        border-radius:14px;
        position:relative;
        box-shadow:0 12px 30px rgba(0,0,0,0.30);
        animation:fadeIn 0.25s ease;
    ">
        
        <!-- Close Button -->
        <button onclick="closeQuote()" style="
            position:absolute; top:12px; right:12px;
            background:#eee; border:none;
            width:34px; height:34px;
            border-radius:50%;
            font-size:20px; font-weight:bold;
            cursor:pointer;
        ">×</button>

        <h2 style="color:#075818; font-weight:700; margin-bottom:20px;">
            Get Your FREE Quote
        </h2>

        <form method="post" action="<?php echo base_url('home/send_message'); ?>">

            <div class="row">
                <div class="col-sm-6 mb-3">
                    <label>Full Name</label>
                    <input type="text" name="name" class="form-control" required>
                </div>

                <div class="col-sm-6 mb-3">
                    <label>Email Address</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6 mb-3">
                    <label>Phone Number</label>
                    <input type="text" name="phone" class="form-control" required>
                </div>

                <div class="col-sm-6 mb-3">
                    <label>Requested Service</label>
                    <input type="text" name="service" class="form-control" placeholder="Landscaping, Turf, Patio..." required>
                </div>
            </div>

            <div class="mb-3">
                <label>Address of Service</label>
                <input type="text" name="address" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Message</label>
                <textarea name="message" class="form-control" rows="5" placeholder="Tell us what you need..." required></textarea>
            </div>

            <button type="submit" style="
                background:#34a906;
                border:none;
                padding:14px 30px;
                color:#fff;
                border-radius:30px;
                font-weight:600;
                cursor:pointer;
                font-size:16px;
            ">Send Quote Request</button>

        </form>
    </div>
</div>

<style>
@keyframes fadeIn {
    from {opacity:0; transform:scale(0.95);}
    to {opacity:1; transform:scale(1);}
}

/* MOBILE-ONLY FIX — allows the popup to scroll */
@media (max-width: 768px) {

    #quotePopup {
        overflow-y: auto !important;       /* Enables scrolling */
        align-items: flex-start !important;
        padding-top: 40px !important;
        padding-bottom: 40px !important;
    }

    #quotePopup > div {
        margin-top: 20px !important;
        margin-bottom: 40px !important;
    }
}
</style>

<script>
function openQuote() {
    document.getElementById('quotePopup').style.display = 'flex';
    document.body.style.overflow = 'hidden'; // prevents background scroll
}

function closeQuote() {
    document.getElementById('quotePopup').style.display = 'none';
    document.body.style.overflow = 'auto';
}

// Keep your original trigger system EXACTLY:
document.addEventListener("DOMContentLoaded", function() {
    document.querySelectorAll('.open-quote').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            openQuote();
        });
    });
});
</script>

    <?php endif ?>

<?php else: ?>
    <?php include"company_footer.php"; ?>
<?php endif; ?>


</div>

    <?php if (settings()->enable_pwa == 1): ?>
        <a class="btn btn-primary bg-primary-soft" id="installPwa" href="#" style="display: none"><i class="bi bi-arrow-down-circle-fill fs-15"></i> <?php echo trans('install-pwa') ?></a>
    <?php endif; ?>

    <?php include'js_msg_list.php'; ?>

    <input type="hidden" id="base_url" value="<?php echo base_url(); ?>">
    <?php $success = $this->session->flashdata('msg'); ?>
    <?php $error = $this->session->flashdata('error'); ?>

    <input type="hidden" id="success" value="<?php if(isset($success)){echo html_escape($success);} ?>">
    <input type="hidden" id="error" value="<?php if(isset($error)){echo html_escape($error);} ?>">  
    <input type="hidden" id="cp" value="<?php echo strlen(settings()->purchase_code);?>">
    <a href="javascript:void(0)" class="scroll-to-top"><i class="fa fa-angle-up"></i></a> 
    <input type="hidden" id="country_code" value="<?php echo strtolower(settings()->code); ?>">
    <input type="hidden" id="lan_type" value="<?php echo text_dir(); ?>">
    <?php echo $this->session->unset_userdata('msg'); $this->session->unset_userdata('error'); ?>
    <!-- Global JS -->
    <script src="<?php echo base_url() ?>assets/front/libs/jquery/dist/jquery.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/popper.js/dist/umd/popper.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/owl-carousel/dist/js/owl.carousel.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/svg-injector/dist/svg-injector.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/jarallax/dist/jarallax.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/svg-injector/dist/svg-injector.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/libs/easy-responsive-tabs/js/easyResponsiveTabs.js"></script>
   
    <!-- Custom JS -->
    <script src="<?php echo base_url() ?>assets/front/js/template.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/front/js/custom.js?var=<?= settings()->version ?>&time=<?=time();?>"></script>
    <script src="<?php echo base_url()?>assets/admin/js/sweet-alert.min.js"></script>
    <script src="<?php echo base_url() ?>assets/admin/js/validation.js"></script>
    <script src="<?php echo base_url()?>assets/admin/js/tata.js"></script>
    
    <!-- animation js -->
    <?php if(settings()->enable_animation == 1): ?>
        <script src="<?php echo base_url() ?>assets/front/js/aos.js"></script>
    <?php endif; ?>
    
    <!-- nice select js -->
    <script src="<?php echo base_url()?>assets/admin/js/nice-select.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/js/owl.carousel.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/js/moment.min.js"></script>
    <script type="text/javascript" src="<?php echo base_url() ?>assets/front/js/daterangepicker.js"></script>
    <!-- select2 js -->
    <script src="<?php echo base_url()?>assets/admin/plugins/select2/js/select2.full.min.js"></script>
    <!-- date & time picker -->
    <script src="<?php echo base_url() ?>assets/admin/js/bootstrap-datepicker.min.js"></script>
    <script src="<?php echo base_url()?>assets/admin/js/timepicker.min.js"></script>
    <script src="<?php echo base_url() ?>assets/front/js/lightbox.js"></script>
    <script src="<?php echo base_url() ?>assets/front/js/intlInputPhone.js"></script>


    <script src="<?php echo base_url() ?>assets/admin/plugins/datatables/jquery.dataTables.js"></script>
    <script src="<?php echo base_url() ?>assets/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.js"></script>
    
    <script src="<?php echo base_url() ?>assets/front/libs/justified-gallery/justifiedGallery.min.js"></script>
    <!-- <script src="<?php echo base_url() ?>assets/front/js/filtergallery.min.js"></script>
    <script>
        var containerEl = document.querySelector('.containers');
        var mixer = mixitup(containerEl);
    </script> -->

    <!-- stripe js -->
    <?php $this->load->view('admin/include/stripe-js.php');?>


    <div id="load_work">
        <?php $this->load->view('include/custom-js.php');?>
    </div>


    <?php if (isset($menu) && $menu == FALSE): ?>
        <?php $terms_url = base_url('terms-and-conditions/'.$slug); ?>
    <?php else: ?>
        <?php $terms_url = base_url('page/terms-of-service'); ?>
    <?php endif; ?>
 
    <!-- gdpr compliance code -->
    
    <?php if (isset($page_title) && $page_title == 'Appointments' || $page_title == 'Events'): ?>
        <script type="text/javascript">
          <?php if ($company->time_format == 'HH'): ?>
            $(document).on("focusin",".timepicker", function () {
              $('input.timepicker').timepicker({ timeFormat: 'HH:mm', interval: 30 });
            });
          <?php else: ?>
            $(document).on("focusin",".timepicker", function () {
              $('input.timepicker').timepicker({ timeFormat: 'hh:mm p', interval: 30 });
            });
          <?php endif ?>
        </script>
    

        <script type="text/javascript">

             // daterangepicker
            $(function() {
               
              $('input[name="daterange"]').daterangepicker({
                opens: 'left',
                locale: {
                  format: 
                    'YYYY/MM/DD',
                    "applyLabel": "<?php echo trans('apply') ?>",
                    "cancelLabel": "<?php echo trans('cancel') ?>",
                    "fromLabel": "<?php echo trans('from') ?>",
                    "toLabel": "<?php echo trans('to') ?>",
                    "customRangeLabel": "<?php echo trans('custom') ?>",
                    "daysOfWeek": [
                        "<?php echo trans('su') ?>",
                        "<?php echo trans('mo') ?>",
                        "<?php echo trans('tu') ?>",
                        "<?php echo trans('we') ?>",
                        "<?php echo trans('th') ?>",
                        "<?php echo trans('fr') ?>",
                        "<?php echo trans('sa') ?>"
                    ],
                    "monthNames": [
                        "<?php echo trans('january') ?>",
                        "<?php echo trans('february') ?>",
                        "<?php echo trans('march') ?>",
                        "<?php echo trans('april') ?>",
                        "<?php echo trans('may') ?>",
                        "<?php echo trans('june') ?>",
                        "<?php echo trans('july') ?>",
                        "<?php echo trans('august') ?>",
                        "<?php echo trans('september') ?>",
                        "<?php echo trans('october') ?>",
                        "<?php echo trans('november') ?>",
                        "<?php echo trans('december') ?>"
                    ]
                }
                
              }, function(start, end, label) {
                // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
              });
            });
        </script>
    <?php endif ?>

    

    <?php if (isset($page_title) && $page_title == 'Staff Holidays'): ?>
        <script src="<?php echo base_url() ?>assets/admin/js/jquery-ui.min.js"></script>
        <script>
            $(document).ready(function () {

                var $datePicker = $("#holiday_picker");
                var base_url = $('#base_url').val();

                <?php $staff_holidays=get_by_id($this->session->userdata('id'),'staffs'); ?>
                var disabledDays = <?php echo $staff_holidays->holidays; ?>
                
               

                $.datepicker.regional ['en'] = {
                    clearText: 'Clear', 
                    clearStatus: '',
                    closeText: 'Close',
                    closeStatus: 'Close without modifying',
                    prevStatus: 'See previous month',
                    nextStatus: 'See next month',
                    currentText: 'Current',
                    currentStatus: 'See current month',
                    monthNames: ['<?php echo trans('january') ?>', '<?php echo trans('february') ?>', '<?php echo trans('march') ?>', '<?php echo trans('april') ?>', '<?php echo trans('may') ?>', '<?php echo trans('june') ?>',
                    '<?php echo trans('july') ?>', '<?php echo trans('august') ?>', '<?php echo trans('september') ?>', '<?php echo trans('october') ?>', '<?php echo trans('november') ?>', '<?php echo trans('december') ?>'],
                    monthNamesShort: ['<?php echo trans('january') ?>', '<?php echo trans('february') ?>', '<?php echo trans('march') ?>', '<?php echo trans('april') ?>', '<?php echo trans('may') ?>', '<?php echo trans('june') ?>',
                    '<?php echo trans('july') ?>', '<?php echo trans('august') ?>', '<?php echo trans('september') ?>', '<?php echo trans('october') ?>', '<?php echo trans('november') ?>', '<?php echo trans('december') ?>'],
                    monthStatus: 'See another month',
                    yearStatus: 'See another year',
                    weekHeader: 'Sm',
                    weekStatus: '',
                    dayNames: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
                    dayNamesShort: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
                    dayNamesMin: ['<?php echo trans('su') ?>', '<?php echo trans('mo') ?>', '<?php echo trans('tu') ?>', '<?php echo trans('we') ?>', '<?php echo trans('th') ?>', '<?php echo trans('fr') ?>', '<?php echo trans('sa') ?>'],
                    dayStatus: 'Use DD as the first day of the week',
                    dateStatus: 'Choose the DD, MM of',
                    firstDay: 0,
                    initStatus: 'Choose date',
                    isRTL: false
                }; 

                $.datepicker.setDefaults($.datepicker.regional['en']);

                $datePicker.datepicker({
                    daysOfWeekDisabled: [0],
                    changeMonth: true,
                    changeYear: true,
                    showOtherMonths: true,
                    selectOtherMonths: true,
                    showButtonPanel: true,
                    todayBtn: false,
                    dateFormat: 'yy-m-d',

                    onSelect: function(){
                        var date = $(this).val();
                        $('.booking_time').val('');

                        var url = base_url+'staff/add_holidays/'+date;
                        var post_data = {
                            'csrf_test_name' : csrf_token
                        };

                        $('#load_data').html('<span class="spinner-border spinner-border-sm"></span>');

                        $.ajax({
                            type: "POST",
                            url: url,
                            dataType: 'json',
                            data: post_data,
                            success: function(data) {
                                if (data.status == 1) {
                                    window.location.href = base_url+'staff/holidays?msg=success';
                                }
                            }
                        })

                    },


                    beforeShowDay: function(date) {
                        var m = date.getMonth(), d = date.getDate(), y = date.getFullYear();
                        for (i = 0; i < disabledDays.length; i++) {
                            if($.inArray(y + '-' + (m+1) + '-' + d,disabledDays) != -1) {
                                //return [false];
                                return [true, 'ui-state-actived', ''];
                            }
                        }
                        return [true];
                    }

                });
            });
        </script>
    <?php endif ?>




<!-- Event code -->


<?php if (isset($countdown) && $countdown == 'TRUE'): ?>
    
<script src="<?php echo base_url() ?>assets/front/libs/countup/jquery.counterup.min.js"></script>

<script>
    $(document).ready(function () {
        var end = $('#event_countdown_date').val();
        var end = new Date(end);

        //alert(end); return false;

        var _second = 1000;
        var _minute = _second * 60;
        var _hour = _minute * 60;
        var _day = _hour * 24;
        var timer;

        function showRemaining() {
            var now = new Date();
            var distance = end - now;
            if (distance < 0) {

                clearInterval(timer);
                document.getElementById('countdown').innerHTML = 'EXPIRED!';

                return;
            }
            var days = Math.floor(distance / _day);
            var hours = Math.floor((distance % _day) / _hour);
            var minutes = Math.floor((distance % _hour) / _minute);
            var seconds = Math.floor((distance % _minute) / _second);

            // document.getElementById('countdown').innerHTML = days + 'days ';
            // document.getElementById('countdown').innerHTML += hours + 'hrs ';
            // document.getElementById('countdown').innerHTML += minutes + 'mins ';
            // document.getElementById('countdown').innerHTML += seconds + 'secs';





            document.getElementById('countdown').innerHTML =
                "<div>" +
                days +
                "<span><?= trans('days'); ?></span></div><div>" +
                hours +
                "<span><?= trans('hours'); ?></span></div><div>" +
                minutes +
                "<span><?= trans('minutes'); ?></span></div><div>" +
                seconds +
                "<span><?= trans('seconds'); ?></span></div>";
        }

        timer = setInterval(showRemaining, 1000);
    });
</script>

<script>
    $(document).ready(function () {
        var end = $('#ticket_countdown_date').val();
        var end = new Date(end);

        //alert(end); return false;

        var _second = 1000;
        var _minute = _second * 60;
        var _hour = _minute * 60;
        var _day = _hour * 24;
        var timer;

        function showRemaining() {
            var now = new Date();
            var distance = end - now;
            if (distance < 0) {

                clearInterval(timer);
                document.getElementById('countdown_ticket').innerHTML = 'EXPIRED!';

                return;
            }
            var days = Math.floor(distance / _day);
            var hours = Math.floor((distance % _day) / _hour);
            var minutes = Math.floor((distance % _hour) / _minute);
            var seconds = Math.floor((distance % _minute) / _second);

            document.getElementById('countdown_ticket').innerHTML = days +' '+ '<?= trans('days'); ?> ';
            document.getElementById('countdown_ticket').innerHTML += hours +' '+ '<?= trans('hours'); ?> ';
            document.getElementById('countdown_ticket').innerHTML += minutes +' '+ '<?= trans('minutes'); ?> ';
            document.getElementById('countdown_ticket').innerHTML += seconds +' '+ '<?= trans('seconds'); ?>';


            
        }

        timer = setInterval(showRemaining, 1000);
    });
</script>
<?php endif ?>

<script type="text/javascript">

    $(document).ready(function () {
        $(".booking_btn").on('click', function() {
            $(".booking_details").hide();
            $(".booking_btn").hide();
            $(".booking_option").show();
            
        });
    });

    $(document).ready(function () {
        $(".event_step2_back_btn").on('click', function() {
            $(".back_to_events").show();
            $(".booking_details").hide();
            $(".booking_btn").hide();
            $(".booking_option").show();
            $(".event_booking_step_2").hide();
            
        });
    });



    $('#event_booking_form').on("submit", function() {
       var msg_processing = 'processing'; 

      $(".event_step2_btn").html('<span class="spinner-border spinner-border-sm"></span> &nbsp; '+msg_processing);
       
        $('.event_step2_btn').prop('disabled', true)
        $.post($(this).attr('action'), $(this).serialize(), function(json){
          if (json.st == 1) {
              $(".error").hide();
              $(".success").html('<i class="fa fa-check-circle"></i> '+json.msg);
              
              //checking if it is an iframe
              if (window.self !== window.top) { 
                window.parent.location.href = json.url;
              } else {
                window.location.href = json.url;
              }
          }else if(json.st == 0) {;
              $(".error").show().html('<i class="fa fa-exclamation-circle"></i> '+json.msg);
          }else if(json.st == 3) {
              $(".error").show().html('<i class="icon-exclamation"></i> '+json.error);
          }else if(json.st == 6) {
              $(".error").show().html('<i class="icon-exclamation"></i> '+json.msg);
          }
      },'json');
      return false;
    });


    $(".event_booking_terms_btn").on('click', function() {
        if ($(".event_booking_terms_btn").is(":checked")) {
            $('.event_step2_btn').prop('disabled', false);
        } else {
            $('.event_step2_btn').prop('disabled', true);
        }
    });


    $(document).on('change', ".ticket_input", function() {

        var event_id = $(this).val();
        if(event_id){
            $('.ticket_quantity').show();
        }  
        return false;
    });


    $(document).on('keyup change', ".quantity", function() {

        var quantity = $(this).val();
        var tickets_per_attendee = $('.tickets_per_attendee').val();

        if(quantity){
            $('.continue_btn').prop('disabled', false);
        }
        return false;
    });


    $(".event_click_new").on('click', function() {
        $('.event_is_customer_exist').val(0);
        $('.event_guest_hide').show();
    });

    $(".event_click_old").on('click', function() {
        $('.event_is_customer_exist').val(1);
    });

    $(".event_click_guest").on('click', function() {
        $('.event_is_customer_exist').val(2);
        $('.event_guest_hide').hide();
    });


    $(document).on('change', ".event_pay_info", function() {
        var infoVal = $(this).val();
        
        //alert(infoVal); return false;

        if (infoVal == '1') {
            $('.event_payments_area').show();
            $('.event_confirm_area').hide();
        } else {
            $('.event_payments_area').hide();
            $('.event_confirm_area').show();
        }
    });

</script>



<!-- event code -->

<?php if (isset($page_title) && $page_title == 'Booking Confirm'): ?>
    <script type="text/javascript">
        $(document).ready(function () {
            var base_url = '<?php echo base_url() ?>';
            var slug = '<?php echo $slug ?>';
            var booking_id = '<?php echo $booking_id ?>';

            var url = base_url+'company/send_booking_notifications/'+slug+'/'+booking_id;
            var post_data = {
                'csrf_test_name' : csrf_token
            };

            $.ajax({
                type: "POST",
                url: url,
                dataType: 'json',
                data: post_data,
                success: function(data) {
                    if (data.status == 1) {
                        console.log('Email notification sent successfully');
                        //window.location.href = base_url+'';
                    }
                }
            });
        });
    </script>
<?php endif; ?>


<!-- PWA -->
<?php if (settings()->enable_pwa == 1): ?>
    <?php include 'pwa_footer_js.php'; ?>
<?php endif; ?>
<!-- PWA -->

</body>


</html>