<!-- HERO SECTION – EXCAVATION -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Excavation & Site Preparation Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor provides professional excavation, grading, and digging services to prepare
            your property for new construction, landscaping, drainage, and outdoor projects.
        </p>
    </div>
</section>

<!-- EXCAVATION VISUAL SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container" style="max-width:1100px;">

        <div class="row align-items-center">

            <!-- Image -->
            <div class="col-md-6 mb-4 mb-md-0">
                <img 
                    src="/uploads/Excavation.webp"
                    alt="Excavation and site preparation for outdoor construction projects"
                    title="Professional Excavation & Site Preparation"
                    style="
                        width:100%;
                        border-radius:18px;
                        box-shadow:0 14px 36px rgba(0,0,0,0.18);
                    ">
            </div>

            <!-- Content -->
            <div class="col-md-6">
                <h2 style="
                    color:#075818;
                    font-weight:800;
                    font-size:34px;
                    margin-bottom:18px;
                ">
                    Clean, Precise Excavation Done Right
                </h2>

                <p style="
                    font-size:18px;
                    color:#333;
                    line-height:1.7;
                    margin-bottom:18px;
                ">
                    Excavation is the first and most important step of any outdoor project. At Aversa Outdoor,
                    we focus on accuracy, safety, and clean execution to prepare your property the right way.
                </p>

                <p style="
                    font-size:17px;
                    color:#555;
                    line-height:1.7;
                ">
                    From grading land for proper drainage to digging footers for patios, walkways, and
                    outdoor structures, our team ensures your site is level, stable, and ready for
                    construction or landscaping. Every cut, slope, and depth is handled with care
                    to support long-lasting results.
                </p>
            </div>

        </div>

    </div>
</section>


<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose Professional Excavation?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            Proper excavation creates a safe, stable foundation for any outdoor build. Our crew uses
            the right equipment and techniques to dig, grade, and prepare land with accuracy and care.
            Whether you’re starting a new project or improving an existing space, good excavation is
            the key to long-lasting results.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Precise Grading
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Smooth, even ground ready for patios, turf, driveways, and landscaping.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Safe & Controlled Digging
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Professional digging for trenches, footers, drainage, and more.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Strong Site Preparation
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Creates a solid base for construction and outdoor living features.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            What Our Excavation Services Include
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Grading and leveling for landscaping</li>
                <li>Digging for drainage and utility lines</li>
                <li>Site preparation for patios and hardscapes</li>
                <li>Excavation for walkways and driveways</li>
                <li>Soil removal and ground clearing</li>
                <li>Trench digging and small-scale earthwork</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Need Professional Excavation or Site Prep?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our team provides clean, precise excavation to prepare your outdoor project the right way.
            From grading to digging, we ensure every job starts with a solid foundation.
        </p>

        <div style="
            margin-top:25px; display:flex; gap:10px; align-items:center;
            justify-content:center; flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%; height:420px; border-radius:16px; overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" allowfullscreen loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- EXCAVATION FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Excavation & Site Prep FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Helpful answers about our excavation and grading services.
            </p>
        </div>

        <div class="accordion" id="excavationFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px;
                 box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="excavationFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#excavationAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What is excavation used for?
                        </button>
                    </h3>
                </div>

                <div id="excavationAnswer1" class="collapse" data-parent="#excavationFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Excavation prepares your ground for building or landscaping. This includes 
                        removing soil, leveling uneven areas, digging trenches, and creating a 
                        stable base for outdoor projects.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px;
                 box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="excavationFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#excavationAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does excavation take?
                        </button>
                    </h3>
                </div>

                <div id="excavationAnswer2" class="collapse" data-parent="#excavationFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Most small excavation projects take one day. Larger sites may require 
                        additional time depending on soil type, access, and project complexity.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px;
                 box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="excavationFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#excavationAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do you handle grading for drainage?
                        </button>
                    </h3>
                </div>

                <div id="excavationAnswer3" class="collapse" data-parent="#excavationFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we grade properties to help control water flow and prevent pooling.
                        Proper grading protects your home and outdoor areas from drainage issues.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px;
                 box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="excavationFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#excavationAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Can excavation damage my yard?
                        </button>
                    </h3>
                </div>

                <div id="excavationAnswer4" class="collapse" data-parent="#excavationFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We take steps to protect your property. Our equipment and methods 
                        minimize impact and keep the work area clean and controlled.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
