<!-- SOFT GREEN HERO SECTION -->
<section style="background:#e9f7e9; padding:90px 0;">
    <div class="container">
        <div class="row align-items-center">

            <!-- HERO TEXT -->
            <div class="col-md-6 mb-5 mb-md-0">
                <h1 style="font-size:48px; font-weight:700; color:#075818; margin-bottom:20px;">
                    Aversa Outdoor - Landscaping & Outdoor Living Services
                </h1>

                <p style="font-size:18px; color:#223322; max-width:480px; line-height:1.6;">
                    Aversa Outdoor provides professional landscaping, outdoor living, and artificial turf services designed to improve how your outdoor space looks and functions. We create clean, natural outdoor areas that are easy to enjoy, low-maintenance, and built to last for everyday living.
                </p>

                <!-- CTA BUTTONS WRAPPER -->
                <div style="margin-top:25px; display:flex; gap:12px; align-items:center; flex-wrap:wrap;">

                    <!-- MAIN CTA -->
                    <a href="/services"
                       style="
                           background:#34a906;
                           color:#fff;
                           padding:14px 34px;
                           border-radius:30px;
                           font-size:16px;
                           font-weight:600;
                           text-decoration:none;
                           transition:0.2s ease;
                       "
                       onmouseover="this.style.background='#2a9005'"
                       onmouseout="this.style.background='#34a906'">
                        Explore Outdoor Services
                    </a>

                    <!-- CALL NOW BUTTON -->
                    <a href="tel:(941)-274-1505"
                       style="
                           background:#ffffff;
                           color:#34a906;
                           border:2px solid #34a906;
                           padding:10px 16px;
                           border-radius:50px;
                           font-size:15px;
                           font-weight:600;
                           text-decoration:none;
                           display:flex;
                           align-items:center;
                           gap:8px;
                           transition:0.2s ease;
                       "
                       onmouseover="this.style.background='#f2fff0'"
                       onmouseout="this.style.background='#ffffff'">

                        <!-- Phone Icon (Bootstrap Icons) -->
                        <i class="bi bi-telephone-fill" style="font-size:16px;"></i>

                        Call Now
                    </a>

                </div>
                
            </div>

            <!-- HERO IMAGE -->
            <div class="col-md-6">
                <img src="/uploads/driveway-construction.webp"
                     alt="Outdoor Living Garden Area"
                     style="width:100%; border-radius:12px; box-shadow:0 12px 28px rgba(0,0,0,0.15);">
            </div>

        </div>
    </div>
</section>



<!-- CORE SERVICES (TOP 3) -->
<section style="padding:80px 0;">
    <div class="container text-center" style="max-width:760px; margin-bottom:50px;">
        <h2 style="color:#075818; font-weight:700; margin-bottom:15px;">Landscaping, Outdoor Living & Turf Solutions</h2>
        <p style="color:#555; font-size:18px;">
            We design, build, and care for outdoor spaces that look beautiful, feel inviting,
            and work well for everyday living.
        </p>
    </div>

    <div class="container">
        <div class="row g-4">

            <!-- Service 1 -->
            <div class="col-md-4">
                <div style="
                    background:#fff;
                    border-radius:12px;
                    padding:28px;
                    height:100%;
                    border:1px solid rgba(0,0,0,0.05);
                    box-shadow:0 8px 22px rgba(0,0,0,0.08);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700;">Landscaping Design</h3>
                    <p style="font-size:14px; color:#555;">
                        Fresh plants, clean layouts, and designs made to match your home's style.
                    </p>
                    <a href="/services/landscape-design" title="Landscape Design Services" style="
                        color:#34a906;
                        font-weight:600;
                        text-decoration:none;
                    ">Learn More →</a>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="col-md-4">
                <div style="
                    background:#fff;
                    border-radius:12px;
                    padding:28px;
                    height:100%;
                    border:1px solid rgba(0,0,0,0.05);
                    box-shadow:0 8px 22px rgba(0,0,0,0.08);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700;">Outdoor Living Spaces</h3>
                    <p style="font-size:14px; color:#555;">
                        Patios, seating areas, and custom outdoor spaces made for everyday comfort.
                    </p>
                    <a href="/services/outdoor-living-spaces" style="
                        color:#34a906;
                        font-weight:600;
                        text-decoration:none;
                    ">Learn More →</a>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="col-md-4">
                <div style="
                    background:#fff;
                    border-radius:12px;
                    padding:28px;
                    height:100%;
                    border:1px solid rgba(0,0,0,0.05);
                    box-shadow:0 8px 22px rgba(0,0,0,0.08);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700;">Artificial Turf Installation</h3>
                    <p style="font-size:14px; color:#555;">
                        Always-green turf that stays clean, bright, and low-maintenance all year.
                    </p>
                    <a href="/services/artificial-turf-installation" style="
                        color:#34a906;
                        font-weight:600;
                        text-decoration:none;
                    ">Learn More →</a>
                </div>
            </div>

        </div>
    </div>
</section>



<!-- FULL SERVICE GRID – FINAL POLISHED VERSION -->
<section style="padding:60px 0; background:#f6fbf6;">
    <div class="container text-center" style="max-width:760px; margin-bottom:25px;">
        <h2 style="color:#075818; font-weight:700;">
            Complete Landscaping, Hardscaping & Outdoor Construction
        </h2>
        <p style="color:#666; font-size:17px; margin-top:10px;">
            Explore our full range of outdoor services.
        </p>
    </div>

    <div style="
        position:relative;
        max-width:1100px;
        margin:auto;
        padding:0 40px; /* room for arrows */
    ">

        <!-- LEFT ARROW -->
        <button id="scrollLeft" style="
            position:absolute; left:0; top:50%;
            transform:translateY(-50%);
            background:#075818;
            color:#fff;
            border:none;
            padding:10px 12px;
            border-radius:8px;
            cursor:pointer;
            z-index:20;
        ">←</button>

        <!-- CAROUSEL -->
        <div class="service-scroller" style="
            display:flex;
            gap:20px;
            overflow-x:auto;
            scroll-behavior:smooth;
            padding:10px 0;
            scrollbar-width:none;
            -ms-overflow-style:none;
        ">
            <!-- Cards -->
            <div class="service-card">
                <h3>Land Clearing</h3>
                <p>Clear out trees and brush to prepare your space for new projects.</p>
            </div>

            <div class="service-card">
                <h3>Artificial Turf Installation</h3>
                <p>Low-maintenance turf that stays green all year.</p>
            </div>

            <div class="service-card">
                <h3>Concrete Masonry</h3>
                <p>Strong, stylish concrete for patios and walkways.</p>
            </div>

            <div class="service-card">
                <h3>Driveway Landscaping</h3>
                <p>Clean borders and greenery for curb appeal.</p>
            </div>

            <div class="service-card">
                <h3>Driveway & Walkway Paving</h3>
                <p>Durable paving that upgrades your entrance.</p>
            </div>

            <div class="service-card">
                <h3>Outdoor Planting Design</h3>
                <p>Beautiful planting layouts designed for your space.</p>
            </div>

            <div class="service-card">
                <h3>Landscape Design</h3>
                <p>Outdoor layouts that blend beauty & function.</p>
            </div>

            <div class="service-card">
                <h3>Retaining Walls</h3>
                <p>Strong walls that support your yard.</p>
            </div>

            <div class="service-card">
                <h3>Concrete Work</h3>
                <p>Custom concrete for patios, paths & more.</p>
            </div>

            <div class="service-card">
                <h3>Patio Construction</h3>
                <p>Custom patios built for comfort and style.</p>
            </div>

            <div class="service-card">
                <h3>Drainage & Excavation</h3>
                <p>Water control and grading solutions.</p>
            </div>

            <div class="service-card">
                <h3>Tree Removal</h3>
                <p>Safe removal for unwanted or damaged trees.</p>
            </div>
        </div>

        <!-- RIGHT ARROW -->
        <button id="scrollRight" style="
            position:absolute; right:0; top:50%;
            transform:translateY(-50%);
            background:#075818;
            color:#fff;
            border:none;
            padding:10px 12px;
            border-radius:8px;
            cursor:pointer;
            z-index:20;
        ">→</button>

    </div>
</section>

<style>
.service-card {
    min-width: 250px;
    background: #fff;
    border-radius: 12px;
    padding: 24px;
    border: 1px solid rgba(0,0,0,0.06);
    box-shadow: 0 4px 14px rgba(0,0,0,0.06);
    display: flex;
    flex-direction: column;   /* <-- FORCES vertical alignment */
    justify-content: flex-start;
    text-align: center;
}
.service-card h3 {
    color:#075818;
        font-size:22px;
    font-weight:700;
    margin-bottom: 8px;       /* <-- space between heading & paragraph */
    display: block;
}
.service-card p {
    font-size:16px;
    color:#555;
    margin: 0;
    display: block;
    text-align: center !important;
}
.service-scroller::-webkit-scrollbar { display:none; }
</style>

<script>
const scroller = document.querySelector('.service-scroller');
document.getElementById('scrollLeft').onclick = () => scroller.scrollBy({ left:-260, behavior:'smooth' });
document.getElementById('scrollRight').onclick = () => scroller.scrollBy({ left:260, behavior:'smooth' });
</script>

<!-- CTA SECTION (SOFT GREEN) -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Refresh Your Outdoor Space?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Whether you want new landscaping, a custom patio, or year-round turf, 
            Aversa Outdoor makes it simple. Tell us your vision and we'll bring it to life.
        </p>

        <a class="open-quote" href="/contact" 
           style="
               display:inline-block;
               background:#34a906;
               color:#fff;
               padding:16px 40px;
               border-radius:30px;
               font-size:18px;
               font-weight:600;
               text-decoration:none;
               transition:0.2s ease;
           "
           onmouseover="this.style.background='#2a9005'"
           onmouseout="this.style.background='#34a906'">
            Get a Free Quote
        </a>

    </div>

    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:40px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; margin-bottom:20px; text-align:center;">
                    Find Us Here - Leave A Review!
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:14px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>

            </div>
        </div>
    </div>
</section>

