<!-- HERO SECTION – OUTDOOR PLANTING -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Outdoor Planting Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor creates clean, natural planting layouts that elevate your home’s 
            style. We design and install fresh plants, shrubs, and trees that bring life, 
            balance, and curb appeal to any outdoor space.
        </p>
    </div>
</section>



<!-- SERVICE DETAILS SECTION -->
<section style="padding:70px 0; background:#fff;">
    <div class="container" style="max-width:900px;">

        <h2 style="color:#075818; font-weight:700; text-align:center; margin-bottom:40px;">
            Why Choose Professional Outdoor Planting?
        </h2>

        <p style="font-size:17px; color:#444; line-height:1.7; margin-bottom:30px;">
            The right planting design helps your home look cleaner, more welcoming, and more 
            finished. Our team builds layouts that work with your space, your home design, and 
            the Florida climate — so everything stays healthy and easy to maintain.
        </p>

        <div class="row">

            <!-- Benefit 1 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Clean, Balanced Layouts
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Plant groupings arranged for harmony and strong visual flow.
                    </p>
                </div>
            </div>

            <!-- Benefit 2 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Fresh, Healthy Plants
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        High-quality plants installed with the right soil and spacing.
                    </p>
                </div>
            </div>

            <!-- Benefit 3 -->
            <div class="col-md-4 mb-4">
                <div style="
                    background:#f6fbf6; padding:25px; border-radius:14px; height:100%;
                    text-align:center; border:1px solid rgba(0,0,0,0.06);
                ">
                    <h3 style="color:#075818; font-size:20px; font-weight:700; margin-bottom:10px;">
                        Fits Your Home’s Style
                    </h3>
                    <p style="color:#555; font-size:15px;">
                        Soft, modern, tropical, or simple — designs made for your home.
                    </p>
                </div>
            </div>

        </div>

        <div style="height:20px;"></div>

        <h2 style="
            color:#075818;
            font-weight:700;
            margin-bottom:15px;
            text-align:center;
        ">
            Perfect for Any Outdoor Area
        </h2>

        <div style="display:flex; justify-content:center;">
            <ul style="
                color:#444;
                font-size:17px;
                line-height:1.7;
                list-style:none;
                padding:0;
                margin:0;
                text-align:center;
            ">
                <li>Front yard planting layouts</li>
                <li>Walkway and driveway borders</li>
                <li>Outdoor living areas</li>
                <li>Shrub and hedge installation</li>
                <li>Tree placement and accent planting</li>
                <li>Modern low-maintenance designs</li>
            </ul>
        </div>

    </div>
</section>



<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Ready to Upgrade Your Outdoor Space?
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            Our planting team designs clean, healthy layouts that make your home look fresh 
            and inviting. Enjoy a beautiful outdoor space that feels complete and easy to maintain.
        </p>

        <div style="
            margin-top:25px; display:flex; gap:10px; align-items:center;
            justify-content:center; flex-wrap:wrap;
        ">

            <!-- Quote Button -->
            <a class="open-quote"
               style="
                    background:#34a906;
                    color:#fff;
                    padding:16px 40px;
                    border-radius:30px;
                    font-size:18px;
                    font-weight:600;
                    text-decoration:none;
                    transition:0.2s ease;
               "
               onmouseover="this.style.background='#2a9005'"
               onmouseout="this.style.background='#34a906'">
                Get a Free Quote
            </a>

            <!-- Call Button -->
            <a href="tel:9412741505"
               style="
                    background:#ffffff;
                    color:#34a906;
                    border:2px solid #34a906;
                    padding:12px 20px;
                    border-radius:50px;
                    font-weight:600;
                    font-size:16px;
                    text-decoration:none;
                    display:flex;
                    align-items:center;
                    gap:7px;
               ">
               <i class="bi bi-telephone-fill"></i> Call Now
            </a>

        </div>

    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%; height:420px; border-radius:16px; overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%" height="100%" style="border:0;" allowfullscreen loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>



<!-- OUTDOOR PLANTING – FAQ SECTION -->
<section style="padding:80px 0; background:#f6fbf6;">
    <div class="container">

        <!-- Heading -->
        <div class="text-center mx-md-auto mb-5 mb-md-7" style="max-width:760px;">
            <h2 style="color:#075818; font-weight:700;">
                Outdoor Planting FAQs
            </h2>
            <p style="color:#555; font-size:18px; margin-top:10px;">
                Quick answers to the most common outdoor planting questions.
            </p>
        </div>

        <div class="accordion" id="plantingFaqAccordion">

            <!-- FAQ 1 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="plantingFaq1" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#plantingAnswer1"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            What plants work best in Florida landscapes?
                        </button>
                    </h3>
                </div>

                <div id="plantingAnswer1" class="collapse" data-parent="#plantingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        We choose plants that handle sun, heat, and rain well — including shrubs, 
                        native plants, accents, and low-maintenance options that stay healthy year-round.
                    </div>
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="plantingFaq2" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#plantingAnswer2"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            How long does planting take?
                        </button>
                    </h3>
                </div>

                <div id="plantingAnswer2" class="collapse" data-parent="#plantingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Most planting projects are completed in one day, depending on layout size 
                        and the number of plants being installed.
                    </div>
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="plantingFaq3" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#plantingAnswer3"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Do I need irrigation for new plants?
                        </button>
                    </h3>
                </div>

                <div id="plantingAnswer3" class="collapse" data-parent="#plantingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Irrigation helps plants stay healthy, especially in the first few weeks. 
                        We design planting layouts that work with or without irrigation depending 
                        on plant type.
                    </div>
                </div>
            </div>

            <!-- FAQ 4 -->
            <div class="card mb-3" style="border:none; border-radius:12px; box-shadow:0 4px 16px rgba(0,0,0,0.06);">
                <div class="card-header" id="plantingFaq4" style="background:#fff; border-radius:12px;">
                    <h3 style="font-size:20px; font-weight:700; margin:0;">
                        <button class="btn btn-link collapsed text-dark"
                            type="button" data-toggle="collapse"
                            data-target="#plantingAnswer4"
                            style="font-size:20px; font-weight:700; text-decoration:none;">
                            Are outdoor planting layouts low maintenance?
                        </button>
                    </h3>
                </div>

                <div id="plantingAnswer4" class="collapse" data-parent="#plantingFaqAccordion">
                    <div class="card-body" style="padding:20px 25px; color:#444; line-height:1.7;">
                        Yes — we choose plant types that stay healthy with minimal care, making 
                        your outdoor space easy to manage long-term.
                    </div>
                </div>
            </div>

        </div>

    </div>
</section>
