<!-- HERO SECTION – SERVICES PAGE -->
<section style="background:#e9f7e9; padding:90px 0; text-align:center;">
    <div class="container" style="max-width:760px;">
        
        <h1 style="
            font-size:46px;
            font-weight:800;
            color:#075818;
            margin-bottom:20px;
        ">
            Landscaping, Hardscaping & Outdoor Living Services
        </h1>

        <p style="
            font-size:18px;
            color:#223322;
            line-height:1.7;
        ">
            Aversa Outdoor delivers complete landscaping, hardscaping, turf installation, 
            and outdoor construction services. Explore our full list of solutions designed 
            to elevate your home’s beauty, comfort, and long-term value.
        </p>
    </div>
</section>



<!-- ALL SERVICES GRID -->
<section style="padding:70px 0; background:#fff;">
    <div class="container">

        <div class="text-center" style="max-width:760px; margin:auto; margin-bottom:50px;">
            <h2 style="color:#075818; font-weight:700; margin-bottom:10px;">
                Explore All Outdoor Services
            </h2>
            <p style="color:#555; font-size:17px;">
                From landscape design and hardscaping to concrete work, land clearing, turf, 
                and excavation — we handle everything your outdoor project needs.
            </p>
        </div>

        <div class="row g-4">

            <style>
                .service-box {
                    background:#f6fbf6;
                    border-radius:14px;
                    padding:30px;
                    height:100%;
                    border:1px solid rgba(0,0,0,0.06);
                    text-align:center;
                    transition:0.2s ease;
                }
                .service-box:hover {
                    background:#e9f7e9;
                    transform:translateY(-3px);
                    box-shadow:0px 8px 22px rgba(0,0,0,0.08);
                }
                .service-box h3 {
                    color:#075818;
                    font-size:20px;
                    font-weight:700;
                    margin-bottom:10px;
                }
                .service-box p {
                    color:#555;
                    font-size:15px;
                    margin-bottom:14px;
                }
                .service-box a {
                    color:#34a906;
                    font-weight:600;
                    text-decoration:none;
                }
            </style>


            <!-- 1 Turf -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Artificial Turf Installation</h3>
                    <p>Always-green, low-maintenance turf built to last.</p>
                    <a href="/services/artificial-turf-installation">Learn More →</a>
                </div>
            </div>

            <!-- 2 Concrete Masonry -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Concrete Masonry</h3>
                    <p>Strong, durable concrete for patios, walkways & more.</p>
                    <a href="/services/concrete-masonry">Learn More →</a>
                </div>
            </div>

            <!-- 3 Driveway Landscaping -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Driveway Landscaping</h3>
                    <p>Clean borders and design upgrades for curb appeal.</p>
                    <a href="/services/driveway-landscaping">Learn More →</a>
                </div>
            </div>

            <!-- 4 Driveway & Walkway Paving -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Driveway & Walkway Paving</h3>
                    <p>Quality paving designed for durability and style.</p>
                    <a href="/services/driveway-walkway-paving">Learn More →</a>
                </div>
            </div>

            <!-- 5 Planting / Design (NO GARDEN WORD) -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Outdoor Planting</h3>
                    <p>Fresh plants and clean layouts that fit your home’s style.</p>
                    <a href="/services/outdoor-planting">Learn More →</a>
                </div>
            </div>

            <!-- 6 Landscape Design -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Landscape Design</h3>
                    <p>Thoughtful outdoor layouts built for beauty & function.</p>
                    <a href="/services/landscape-design">Learn More →</a>
                </div>
            </div>

            <!-- 7 Retaining Walls -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Retaining Walls</h3>
                    <p>Strong and stylish walls engineered for support.</p>
                    <a href="/services/retaining-walls">Learn More →</a>
                </div>
            </div>

            <!-- 8 Concrete Work -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Concrete Work</h3>
                    <p>Precision concrete for patios, slabs, and custom builds.</p>
                    <a href="/services/concrete-work">Learn More →</a>
                </div>
            </div>

            <!-- 9 Patio Construction -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Patio Building</h3>
                    <p>Custom patios built for comfort and outdoor living.</p>
                    <a href="/services/patio-building">Learn More →</a>
                </div>
            </div>

            <!-- 10 Drainage & Grading -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Drainage & Grading</h3>
                    <p>Water control solutions that protect your property.</p>
                    <a href="/services/drainage-grading">Learn More →</a>
                </div>
            </div>

            <!-- 11 Driveway Construction -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Driveway Construction</h3>
                    <p>Durable driveway builds with clean, long-lasting finishes.</p>
                    <a href="/services/driveway-construction">Learn More →</a>
                </div>
            </div>

            <!-- 12 Land Clearing -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Land Clearing</h3>
                    <p>Efficient clearing for new builds, landscaping, or expansion.</p>
                    <a href="/services/land-clearing">Learn More →</a>
                </div>
            </div>

            <!-- 13 Tree Removal -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Tree Removal</h3>
                    <p>Safe removal of unwanted, dead, or hazardous trees.</p>
                    <a href="/services/tree-removal">Learn More →</a>
                </div>
            </div>

            <!-- 14 Excavation -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Excavation</h3>
                    <p>Professional grading, digging, and site preparation.</p>
                    <a href="/services/excavation">Learn More →</a>
                </div>
            </div>

            <!-- 15 New Construction Landscaping -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>New Construction Landscaping</h3>
                    <p>Complete start-to-finish landscaping for new homes.</p>
                    <a href="/services/new-construction-landscaping">Learn More →</a>
                </div>
            </div>

            <!-- 16 Outdoor Fireplaces -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Outdoor Fireplaces</h3>
                    <p>Custom outdoor fireplaces for comfort and style.</p>
                    <a href="/services/outdoor-fireplaces">Learn More →</a>
                </div>
            </div>

            <!-- 17 Stone Walls -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Stone Retaining Walls</h3>
                    <p>Natural stone walls with long-lasting strength.</p>
                    <a href="/services/stone-retaining-walls">Learn More →</a>
                </div>
            </div>

            <!-- 18 Walls & Steps -->
            <div class="col-md-4 mb-4">
                <div class="service-box">
                    <h3>Walls & Steps</h3>
                    <p>Custom pathways, steps, and structural wall work.</p>
                    <a href="/services/walls-and-steps">Learn More →</a>
                </div>
            </div>

        </div>

    </div>
</section>


<!-- CTA SECTION -->
<section style="background:#e9f7e9; padding:80px 0;">
    <div class="container text-center" style="max-width:760px;">

        <h2 style="color:#075818; font-weight:700; font-size:36px; margin-bottom:20px;">
            Start Your Outdoor Project Today
        </h2>

        <p style="color:#444; font-size:18px; line-height:1.6; margin-bottom:32px;">
            From turf and landscaping to patios, masonry, drainage, and complete outdoor builds — 
            Aversa Outdoor brings your vision to life with quality, detail, and care.
        </p>

        <a class="open-quote" href="/contact" 
           style="
               display:inline-block;
               background:#34a906;
               color:#fff;
               padding:16px 40px;
               border-radius:30px;
               font-size:18px;
               font-weight:600;
               text-decoration:none;
               transition:0.2s ease;
           "
           onmouseover="this.style.background='#2a9005'"
           onmouseout="this.style.background='#34a906'">
            Get a Free Quote
        </a>
    </div>


    <!-- GOOGLE MAPS -->
    <div class="container" style="margin-top:50px;">
        <div class="row">
            <div class="col-12">

                <h3 style="color:#075818; font-weight:700; font-size:26px; text-align:center; margin-bottom:20px;">
                    Visit or Contact Us
                </h3>

                <div style="
                    width:100%;
                    height:420px;
                    border-radius:16px;
                    overflow:hidden;
                    box-shadow:0 12px 32px rgba(0,0,0,0.15);
                ">
                    <iframe 
                        src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3539.1410893165043!2d-82.53450392454009!3d27.495987276304366!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x88c317ab6e4454e9%3A0xcf58aaff67a401b4!2sAversa%20Outdoor!5e0!3m2!1sen!2sus!4v1765411553324!5m2!1sen!2sus"
                        width="100%"
                        height="100%"
                        style="border:0;"
                        allowfullscreen=""
                        loading="lazy">
                    </iframe>
                </div>

            </div>
        </div>
    </div>
</section>
